import UIKit

class ViewController: UIViewController
{
    @IBOutlet weak var redBox: UIView!

    override func viewDidLoad()
    {
        super.viewDidLoad()
        reset()
    }

    func reset ()
    {
        redBox.center = CGPoint (x: -redBox.frame.size.width / 2,
                                 y: redBox.center.y)
        self.animate()
    }
    
    func animate() -> Void
    {
        UIView.animate(withDuration: 2.0,
                       animations: {
                        self.redBox.center = CGPoint (x: self.view.frame.width + self.redBox.frame.size.width / 2,
                                                 y: self.redBox.center.y)
        }) { (res) in
            self.reset ()
        }
    }

}

